import sys
import os
import hashlib
import hmac
import base64
import requests
import time

def make_signature(access_key, secret_key):
    timestamp = int(time.time() * 1000)
    timestamp = str(timestamp)

    secret_key = bytes(secret_key, 'UTF-8')

    method = "GET"
    uri = "/photos/puppy.jpg?query1=&query2"

    # 메시지 구성 (access_key를 포함하도록 수정)
    message = method + " " + uri + "\n" + timestamp + "\n" + access_key
    message = bytes(message, 'UTF-8')
    
    signingKey = base64.b64encode(hmac.new(secret_key, message, digestmod=hashlib.sha256).digest())
    return signingKey

if __name__ == "__main__":
    # sys.argv[0]은 파일명이고, [1]부터 입력한 파라미터가 들어옵니다.
    if len(sys.argv) < 3:
        print("사용법: python 파일명.py {accessKey} {secretKey}")
        sys.exit(1)

    access_key_input = sys.argv[1]
    secret_key_input = sys.argv[2]

    signature = make_signature(access_key_input, secret_key_input)
    print(signature.decode('utf-8'))
