import asyncio
from agents import Agent, Runner, ModelSettings
from agents.tracing import trace
from dotenv import load_dotenv

load_dotenv()


browser = Agent(
    name="Browser",
    model="computer-use-preview-2025-03-11",
    model_settings=ModelSettings(truncation="auto"),
    instructions="You can do tasks like searching the web, running code, and more.",
)

search = Agent(
    name="Search",
    model="gpt-4o-search-preview-2025-03-11",
    instructions="You can search the web for information.",
)

agent = Agent(
    name="Smith",
    model="gpt-4o-mini",
    instructions="You are a helpful assistant",
    handoffs=[browser, search],
)


async def main():
    prompt = input("Enter a prompt: ")
    with trace(workflow_name="agent_smith"):
        result = await Runner.run(agent, prompt)
        print(result.final_output)


if __name__ == "__main__":
    asyncio.run(main())
@LectomT
Comment
